/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.structure.piece;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import mod.beethoven92.betterendforge.common.block.template.PlantBlock;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModStructurePieces;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class LakePiece
extends StructurePiece {
    private static final BlockState ENDSTONE = Blocks.field_150377_bs.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private Map<Integer, Byte> heightmap = Maps.newHashMap();
    private OpenSimplexNoise noise;
    private BlockPos center;
    private float radius;
    private float aspect;
    private float depth;
    private int seed;
    private ResourceLocation biomeID;

    public LakePiece(BlockPos center, float radius, float depth, Random random, Biome biome) {
        super(ModStructurePieces.LAKE_PIECE, random.nextInt());
        this.center = center;
        this.radius = radius;
        this.depth = depth;
        this.seed = random.nextInt();
        this.noise = new OpenSimplexNoise(this.seed);
        this.aspect = radius / depth;
        this.biomeID = ModBiomes.getBiomeID(biome);
        this.makeBoundingBox();
    }

    public LakePiece(TemplateManager p_i50677_1_, CompoundNBT nbt) {
        super(ModStructurePieces.LAKE_PIECE, nbt);
        this.center = new BlockPos(nbt.func_74762_e("centerX"), nbt.func_74762_e("centerY"), nbt.func_74762_e("centerZ"));
        this.radius = nbt.func_74760_g("radius");
        this.depth = nbt.func_74760_g("depth");
        this.seed = nbt.func_74762_e("seed");
        this.noise = new OpenSimplexNoise(this.seed);
        this.aspect = this.radius / this.depth;
        this.biomeID = new ResourceLocation(nbt.func_74779_i("biomeid"));
        this.makeBoundingBox();
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("centerX", this.center.func_177958_n());
        tagCompound.func_74768_a("centerY", this.center.func_177956_o());
        tagCompound.func_74768_a("centerZ", this.center.func_177952_p());
        tagCompound.func_74776_a("radius", this.radius);
        tagCompound.func_74776_a("depth", this.depth);
        tagCompound.func_74768_a("seed", this.seed);
        tagCompound.func_74778_a("biomeid", this.biomeID.toString());
    }

    private void makeBoundingBox() {
        int minX = ModMathHelper.floor((float)this.center.func_177958_n() - this.radius - 8.0f);
        int minY = ModMathHelper.floor((float)this.center.func_177956_o() - this.depth - 8.0f);
        int minZ = ModMathHelper.floor((float)this.center.func_177952_p() - this.radius - 8.0f);
        int maxX = ModMathHelper.floor((float)this.center.func_177958_n() + this.radius + 8.0f);
        int maxY = ModMathHelper.floor((float)this.center.func_177956_o() + this.depth);
        int maxZ = ModMathHelper.floor((float)this.center.func_177952_p() + this.radius + 8.0f);
        this.field_74887_e = new MutableBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        int minY = this.field_74887_e.field_78895_b;
        int maxY = this.field_74887_e.field_78894_e;
        int sx = chunkPos.field_77276_a << 4;
        int sz = chunkPos.field_77275_b << 4;
        BlockPos.Mutable mut = new BlockPos.Mutable();
        IChunk chunk = world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
        for (int x = 0; x < 16; ++x) {
            mut.func_223471_o(x);
            int wx = x | sx;
            double nx = (double)wx * 0.1;
            int x2 = wx - this.center.func_177958_n();
            for (int z = 0; z < 16; ++z) {
                mut.func_223472_q(z);
                int wz = z | sz;
                double nz = (double)wz * 0.1;
                int z2 = wz - this.center.func_177952_p();
                float clamp = this.getHeightClamp(world, 8, wx, wz);
                if ((double)clamp < 0.01) continue;
                double n = this.noise.eval(nx, nz) * 1.5 + 1.5;
                double x3 = ModMathHelper.pow2((double)x2 + this.noise.eval(nx, nz, 100.0) * 10.0);
                double z3 = ModMathHelper.pow2((double)z2 + this.noise.eval(nx, nz, -100.0) * 10.0);
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos worldPos;
                    BlockState state;
                    mut.func_185336_p((int)((double)y + n));
                    double y2 = ModMathHelper.pow2((float)(y - this.center.func_177956_o()) * this.aspect);
                    double r2 = this.radius * clamp;
                    double r3 = r2 + 8.0;
                    r2 *= r2;
                    r3 = r3 * r3 + 100.0;
                    double dist = x3 + y2 + z3;
                    if (dist < r2) {
                        state = chunk.func_180495_p((BlockPos)mut);
                        if (!this.canReplace(chunk, (BlockPos)mut, state)) continue;
                        state = mut.func_177956_o() < this.center.func_177956_o() ? WATER : AIR;
                        chunk.func_177436_a((BlockPos)mut, state, false);
                        this.removePlant(chunk, mut.func_185334_h().func_177984_a());
                        continue;
                    }
                    if (!(dist <= r3) || mut.func_177956_o() >= this.center.func_177956_o() || (state = chunk.func_180495_p((BlockPos)mut)).func_215686_e((IBlockReader)world, worldPos = mut.func_177982_a(sx, 0, sz)) || state.func_200015_d((IBlockReader)world, worldPos)) continue;
                    state = chunk.func_180495_p(mut.func_177984_a());
                    state = state.func_196958_f() ? (random.nextBoolean() ? ENDSTONE : world.func_226691_t_(worldPos).func_242440_e().func_242502_e().func_204108_a()) : (state.func_204520_s().func_206888_e() ? ENDSTONE : ((Block)ModBlocks.ENDSTONE_DUST.get()).func_176223_P());
                    chunk.func_177436_a((BlockPos)mut, state, false);
                }
            }
        }
        this.fixWater(world, chunk, mut, random, sx, sz);
        return true;
    }

    private boolean canReplace(IChunk chunk, BlockPos pos, BlockState state) {
        if (state.func_235714_a_(ModTags.GEN_TERRAIN) || state.func_196958_f()) {
            return true;
        }
        Block b = state.func_177230_c();
        if (b instanceof PlantBlock && !(b instanceof IWaterLoggable)) {
            this.removePlant(chunk, pos);
            return true;
        }
        return false;
    }

    private void removePlant(IChunk chunk, BlockPos pos) {
        BlockPos p = new BlockPos((Vector3i)pos);
        while (chunk.func_180495_p(p).func_177230_c() instanceof PlantBlock) {
            chunk.func_177436_a(p, AIR, false);
            p = p.func_177984_a();
        }
        p = new BlockPos((Vector3i)pos).func_177977_b();
        while (chunk.func_180495_p(p).func_177230_c() instanceof PlantBlock) {
            chunk.func_177436_a(p, AIR, false);
            p = p.func_177977_b();
        }
    }

    private void fixWater(ISeedReader world, IChunk chunk, BlockPos.Mutable mut, Random random, int sx, int sz) {
        int minY = this.field_74887_e.field_78895_b;
        int maxY = this.field_74887_e.field_78894_e;
        for (int x = 0; x < 16; ++x) {
            mut.func_223471_o(x);
            for (int z = 0; z < 16; ++z) {
                mut.func_223472_q(z);
                block2: for (int y = minY; y <= maxY; ++y) {
                    mut.func_185336_p(y);
                    FluidState state = chunk.func_204610_c((BlockPos)mut);
                    if (state.func_206888_e()) continue;
                    mut.func_185336_p(y - 1);
                    if (chunk.func_180495_p((BlockPos)mut).func_196958_f()) {
                        mut.func_185336_p(y + 1);
                        BlockState bState = chunk.func_180495_p((BlockPos)mut);
                        bState = bState.func_196958_f() ? (random.nextBoolean() ? ENDSTONE : world.func_226691_t_(mut.func_177982_a(sx, 0, sz)).func_242440_e().func_242502_e().func_204108_a()) : (bState.func_204520_s().func_206888_e() ? ENDSTONE : ((Block)ModBlocks.ENDSTONE_DUST.get()).func_176223_P());
                        mut.func_185336_p(y);
                        this.makeEndstonePillar(chunk, mut, bState);
                        continue;
                    }
                    if (x > 1 && x < 15 && z > 1 && z < 15) {
                        mut.func_185336_p(y);
                        for (Direction dir : BlockHelper.HORIZONTAL_DIRECTIONS) {
                            BlockPos wPos = mut.func_177982_a(dir.func_82601_c(), 0, dir.func_82599_e());
                            if (!chunk.func_180495_p(wPos).func_196958_f()) continue;
                            mut.func_185336_p(y + 1);
                            BlockState bState = chunk.func_180495_p((BlockPos)mut);
                            bState = bState.func_196958_f() ? (random.nextBoolean() ? ENDSTONE : world.func_226691_t_(mut.func_177982_a(sx, 0, sz)).func_242440_e().func_242502_e().func_204108_a()) : (bState.func_204520_s().func_206888_e() ? ENDSTONE : ((Block)ModBlocks.ENDSTONE_DUST.get()).func_176223_P());
                            mut.func_185336_p(y);
                            this.makeEndstonePillar(chunk, mut, bState);
                            continue block2;
                        }
                        continue;
                    }
                    if (!chunk.func_180495_p((BlockPos)mut.func_189536_c(Direction.UP)).func_196958_f()) continue;
                    chunk.func_212247_j().func_205360_a((BlockPos)mut.func_189536_c(Direction.DOWN), (Object)state.func_206886_c(), 0);
                }
            }
        }
    }

    private void makeEndstonePillar(IChunk chunk, BlockPos.Mutable mut, BlockState terrain) {
        chunk.func_177436_a((BlockPos)mut, terrain, false);
        mut.func_185336_p(mut.func_177956_o() - 1);
        while (!chunk.func_204610_c((BlockPos)mut).func_206888_e()) {
            chunk.func_177436_a((BlockPos)mut, ENDSTONE, false);
            mut.func_185336_p(mut.func_177956_o() - 1);
        }
    }

    private float getHeightClamp(ISeedReader world, int radius, int posX, int posZ) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        int r2 = radius * radius;
        float height = 0.0f;
        float max = 0.0f;
        for (int x = -radius; x <= radius; ++x) {
            mut.func_223471_o(posX + x);
            int x2 = x * x;
            for (int z = -radius; z <= radius; ++z) {
                mut.func_223472_q(posZ + z);
                int z2 = z * z;
                if (x2 + z2 >= r2) continue;
                float mult = 1.0f - (float)Math.sqrt(x2 + z2) / (float)radius;
                max += mult;
                height += (float)this.getHeight(world, (BlockPos)mut) * mult;
            }
        }
        return MathHelper.func_76131_a((float)(height /= max), (float)0.0f, (float)1.0f);
    }

    private int getHeight(ISeedReader world, BlockPos pos) {
        int p = (pos.func_177958_n() & 0x7FF) << 11 | pos.func_177952_p() & 0x7FF;
        int h = this.heightmap.getOrDefault(p, (byte)-128).byteValue();
        if (h > -128) {
            return h;
        }
        if (!ModBiomes.getBiomeID(world.func_226691_t_(pos)).equals((Object)this.biomeID)) {
            this.heightmap.put(p, (byte)0);
            return 0;
        }
        h = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p());
        h = (h = MathHelper.func_76130_a((int)(h - this.center.func_177956_o()))) < 8 ? 1 : 0;
        this.heightmap.put(p, (byte)h);
        return h;
    }
}

